﻿#include  "StdAfx.h"

#include  "ContextMenuHandler.hpp"
#include  "DllMain.h"
#include  <szPath.hpp>
#include  <szString.hpp>
#include  <buffers.hpp>
#include  <strsafe.h>

SZ_AN_BEG

const MenuItemInfo menuItemInfo[] =
{
  { SZL("Decompress"),         SZL("Decompresses selected files to the same folder."),        IDI_DECOMPRESS, false, false, false },
  { SZL("Compress..."),        SZL("Compresses files / folders with a specified file name."), IDI_COMPRESS,   true,  false, false },
  { SZL("Compress to %s.7z"),  SZL("Compresses files / folders in 7-Zip format."),            IDI_COMPRESS_7, true,  true,  false },
  { SZL("Compress to %s.zip"), SZL("Compresses files / folders in Zip format."),              IDI_COMPRESS_Z, true,  true,  false },
  { SZL("epo Commands"),       SZL("Contains archiving commands of epo."),                    -1,             false, false, true  },
};

SZ_AN_END

using namespace szpp;

CContextMenuHandler::CContextMenuHandler() : m_idCmdFirst(0), m_MenuItems(), CMenuHandlerBase()
{
}

CContextMenuHandler::~CContextMenuHandler()
{
}

// IShellExtInit::Initialize
STDMETHODIMP CContextMenuHandler::Initialize(__in PCIDLIST_ABSOLUTE pidlFolder, __in IDataObject *pdtobj, __in HKEY hkeyProgID)
{
  return InitializeImpl(pidlFolder, pdtobj, hkeyProgID);
}

// IContextMenu::QueryContextMenu
STDMETHODIMP CContextMenuHandler::QueryContextMenu(__in HMENU hmenu, __in UINT indexMenu, __in UINT idCmdFirst, __in UINT idCmdLast, __in UINT uFlags)
{
  if (uFlags & CMF_DEFAULTONLY)
    return MAKE_HRESULT(SEVERITY_SUCCESS, FACILITY_NULL, 0);

  m_MenuItems.clear();

  HMENU hSubmenu = CreatePopupMenu();
  if (hSubmenu == 0)
    return E_FAIL;

  // m_idCmdFirst に一応保存しておく。というのも、InvokeCommand や GetCommandString でメニューを識別するメニュー ID は
  // InsertMenu や InsertMenuItem に渡した uID から m_idCmdFirst を引いたものとなっているので、なにかの拍子に uID とメニュー IDの相互変換が要求されるかもしれないので。
  // これに対して、オーナー描画の lpdis や lpmis の itemID は uID そのものである。
  UINT uID = m_idCmdFirst = idCmdFirst;

  // 最初のセパレータ
  InsertMenu(hmenu, indexMenu++, MF_SEPARATOR | MF_BYPOSITION, 0, 0);

  // サブメニューにコマンドを追加（圧縮コマンド）
  for (int i = 0, j = 0; !menuItemInfo[i].IsSubMenu; ++i)
  {
    const MenuItemInfo &info = menuItemInfo[i];
    if (info.UnderSubMenu)
    {
      if (!info.NeedFormat)
        InsertItem(hSubmenu, j++, uID, GetText(info.Text), info.IconID);
      else
        InsertItem(hSubmenu, j++, uID, Format(GetText(info.Text), m_ArchiveStem.c_str()).c_str(), info.IconID); // 「filename.7z に圧縮」みたいなタイプのコマンド
      m_MenuItems.push_back(MenuItem(uID++, i));
    }
  }

  // 非サブメニュー（主に展開コマンド）
  // 非サブメニューをサブメニュー項目の後に追加しているのは、フォルダのみが選択されている場合には展開メニューが表示されないため、
  // 仮に展開メニューを先に追加することにしていると、インデックス 0 のメニューが存在したりしなかったりしてしまうことになる。
  // そうすると、InvokeCommand の switch の case 文を、状況に応じて変化させないといけなくなるため、
  // 非サブメニューは後ろに持ってくることにしている。
  for (int i = 0; !menuItemInfo[i].IsSubMenu; ++i)
  {
    const MenuItemInfo &info = menuItemInfo[i];
    if (m_HasFile && !info.UnderSubMenu)
    {
      InsertItem(hmenu, indexMenu++, uID, GetText(info.Text), info.IconID);
      m_MenuItems.push_back(MenuItem(uID++, i));
    }
  }

  // サブメニューを追加
  const MenuItemInfo &info = menuItemInfo[ARRAYSIZE(menuItemInfo) - 1];
  MENUITEMINFO mii = { sizeof(MENUITEMINFO) };
  mii.fMask = MIIM_SUBMENU | MIIM_STRING | MIIM_ID;
  mii.wID = uID;
  mii.hSubMenu = hSubmenu;
  mii.dwTypeData = (szchar *)GetText(info.Text);
  InsertMenuItem(hmenu, indexMenu++, TRUE, &mii);
  m_MenuItems.push_back(MenuItem(uID++, ARRAYSIZE(menuItemInfo) - 1));

  // 最後のセパレータ
  InsertMenu(hmenu, indexMenu++, MF_SEPARATOR | MF_BYPOSITION, 0, 0);

  return MAKE_HRESULT(SEVERITY_SUCCESS, FACILITY_NULL, uID - idCmdFirst);
}

// IContextMenu::InvokeCommand
STDMETHODIMP CContextMenuHandler::InvokeCommand(__in CMINVOKECOMMANDINFO *pici)
{
  if (pici->fMask & CMIC_MASK_FLAG_NO_UI)
    return E_FAIL;

  if (0 == m_Files.size())
    return S_OK;

  sbuf<szchar, MAX_PATH> modPath;
  if (0 == GetModuleFileName(hDllInstance, modPath, modPath.size()))
    return E_FAIL;

  const szstring appName = Combine(ExtractDirectory((szchar *)modPath, true), SZL("epolight.exe"), true);
  hbuf<szchar, 32768> cmds;

  switch (LOWORD(pici->lpVerb))
  {
  case 0: // 圧縮
    StringCbPrintf(cmds, cmds.bytes(), SZL("\"%s\" /O \"%s\" /C"), appName.c_str(), m_DirPath.c_str());
    break;
  case 1: // *.7z 圧縮
    StringCbPrintf(cmds, cmds.bytes(), SZL("\"%s\" /O \"%s\" /P \"%s.7z\""),  appName.c_str(), m_DirPath.c_str(), m_ArchiveStem.c_str());
    break;
  case 2: // *.zip 圧縮
    StringCbPrintf(cmds, cmds.bytes(), SZL("\"%s\" /O \"%s\" /P \"%s.zip\""), appName.c_str(), m_DirPath.c_str(), m_ArchiveStem.c_str());
    break;
  case 3: // 展開
    StringCbPrintf(cmds, cmds.bytes(), SZL("\"%s\" /O \"%s\" /D"), appName.c_str(), m_DirPath.c_str());
    break;
  }
  
  // 選択ファイル／フォルダをコマンドラインに追加
  for (size_t i = 0; i < m_Files.size(); ++i)
  {
    sbuf<szchar, MAX_PATH> arcPath;
    StringCbPrintf(arcPath, arcPath.bytes(), SZL(" \"%s\""), m_Files[i].c_str());
    StringCbCat(cmds, cmds.bytes(), arcPath);
  }

  STARTUPINFO sinfo;
  ZeroMemory(&sinfo, sizeof(sinfo));
  sinfo.cb = sizeof(sinfo);

  PROCESS_INFORMATION pinfo;

  if (0 != CreateProcess(0, cmds, 0, 0, FALSE, 0, 0, 0, &sinfo, &pinfo))
    return S_OK;

  return E_FAIL;
}

// IContextMenu::GetCommandString
STDMETHODIMP CContextMenuHandler::GetCommandString(__in UINT_PTR idCmd, __in UINT uType, __reserved UINT *pReserved, __out LPSTR pszName, __in UINT cchMax)
{
  if (m_MenuItems.size() <= idCmd)
    return E_INVALIDARG;

  const szchar *commandString = GetText(menuItemInfo[m_MenuItems[idCmd].GetIndex()].Description);

  if (uType == GCS_HELPTEXTW)
  {
    StringCchCopyW((LPWSTR)pszName, cchMax, CT2CW(commandString));
    return S_OK;
  }
  else if (uType == GCS_HELPTEXTA)
  {
    StringCchCopyA(pszName, cchMax, CT2CA(commandString));
    return S_OK;
  }

  return E_INVALIDARG;
}

// IContextMenu2::HandleMenuMsg
STDMETHODIMP CContextMenuHandler::HandleMenuMsg(__in UINT uMsg, __in WPARAM wParam, __in LPARAM lParam)
{
  LRESULT res;
  return MenuMessageHandler(uMsg, wParam, lParam, &res);
}

// IContextMenu3::HandleMenuMsg2
STDMETHODIMP CContextMenuHandler::HandleMenuMsg2(__in UINT uMsg, __in WPARAM wParam, __in LPARAM lParam, __out LRESULT *plResult)
{
  if (0 == plResult)
  {
    LRESULT res;
    return MenuMessageHandler(uMsg, wParam, lParam, &res);
  }
  return MenuMessageHandler(uMsg, wParam, lParam, plResult);
}

UINT CContextMenuHandler::MenuIdToIconID(UINT uID)
{
  BOOST_FOREACH(MenuItem &item, m_MenuItems)
  {
    if (item.GetID() == uID)
      return menuItemInfo[item.GetIndex()].IconID;
  }
  return ~0;
}
